<%@ taglib uri="/WEB-INF/iscTaglib.xml" prefix="isomorphic" %>

<HTML><HEAD><TITLE>
	Custom ListGrid Pager example
</TITLE>
<isomorphic:loadISC skin="SmartClient" runat="server"/>
</HEAD><BODY MARGINHEIGHT=0 MARGINWIDTH=0 LEFTMARGIN=0 TOPMARGIN=0>

<script>

// Define Grid Pager as a new subclass of VLayout
// This will show a ListGrid and controls to navigate around by "pages" of data
isc.ClassFactory.defineClass("MyGridPager", "VLayout");

isc.MyGridPager.addProperties({


    // pageSize - how many records to show per 'page' of data
    pageSize:50,
    // numPages - how many page navigation buttons to show at one time
    numPages:4,
    // showTotal - should the total number of rows be displayed in the footer
    showTotal:true,
    
    initWidget : function () {
    
        this.Super("initWidget", arguments)
        if (!this.grid) {
            this.logWarn("MyGridPager class requires a specified 'grid' property");
            return;
        }

        // handle being passed an ID
        if (isc.isA.String(this.grid)) this.grid = window[this.grid];
        
        // Allow the listGrid enough space for 1 "page" of data
        var gridHeight = (this.grid.cellHeight * this.pageSize) + this.grid.headerHeight;
        this.setHeight(gridHeight + this.footerHeight);        
        
        // Observe dataChanged on the grid - if the total number of rows changes we may need
        // to rework our pagination
        this.observe(this.grid, "dataChanged", "observer.goToPage(observer.pageNum, true)");
        
        // grid shows up at the top of the VLayout
        this.addMember(this.grid);

        // create the footer - HLayout to contain controls / totals information
        this.makeFooter();
        this.addMember(this.footer);
        
        // create the total label if appropriate
        if (this.showTotal) {
            this.makeTotalLabel();
            this.footer.addMember(this.totalLabel);
        }
        
        // have the paging controls be right-aligned in the footer
        this.footer.addMember(isc.LayoutSpacer.create({width:"*"}));
        
        // create the pager controls
        this.pagerControls = this.makePagerControls();
        this.footer.addMember(this.pagerControls);
        
        // always start at page 1
        this.goToPage(1);
        
        return this.Super("initWidget", arguments);
    },
    
    draw : function () {
        this.Super("draw", arguments);
        // On an external scroll of the grid, ensure we update our pageNum info
        var body = this.grid.body;
        body.addMethods({
            scrolled : new Function (this.getID() + ".listGridScrolled(this.getScrollTop())")
        });

    },
    
    listGridScrolled : function (scrollTop) {
        if (this._scrollingGrid) return;
        var rowNum = scrollTop / this.grid.getRowHeight(),
            // each page spans from start (pageNum-1 * pageSize) to start + pageSize
            start = (this.pageNum-1) * this.pageSize,
            end = start + this.pageSize;
        
        if (rowNum > end || rowNum < start) {
            this.pageNum = Math.ceil(rowNum / this.pageSize);
            this.updatePagerControls();
        }
        
    },
    
    // Footer - will contain total label and page navigation controls
    footerHeight:20,
    
    makeFooter : function () {
        // Footer: an HLayout containing the 'total' label and the paging controls
        this.footer = isc.HLayout.create({
            autoDraw:false,
            height:this.footerHeight, overflow:"hidden",
            memberMargin:10,
            layoutLeftMargin:5, layoutRightMargin:5
        });
        return this.footer;
    },

    // total label
    makeTotalLabel : function () {
        this.totalLabel = isc.Label.create({
            autoDraw:false, 
            creator:this,
            wrap:false, align:"left",
            getTitle: function () {
                return this.creator.getTotalLabelTitle();
            }
        });
        return this.totalLabel;
    },
    
    getTotalLabelTitle : function () {
        var totalRows = this.grid.getTotalRows();
        return "Total Rows:" + totalRows;
    },
    
    // pager navigation controls
    pagerButtonWidth:20,
    
    makePagerControls : function () {
        var pageSize = this.pageSize,
            numPages = this.numPages;
        
        var buttons = [];
        buttons.add(isc.Label.create({
            autoDraw:false,
            width:this.pagerButtonWidth,            
            contents:"&lt;&lt;",
            align:"center",            
            cursor:"hand",
            gridPager:this,
            click:function () {
                this.gridPager.previousPages();
            }
        }));
        
        for (var i = 0; i < numPages; i++) {
            buttons.add(isc.Label.create({
                align:"center",
                autoDraw:false,
                cursor:"hand",
                width:this.pagerButtonWidth,
                gridPager:this,
                click:function () {
                    this.gridPager.goToPage(this.pageNum);
                },
                getTitle : function () {
                    var pageNum = this.pageNum;
                    if (this.gridPager.pageNum == this.pageNum) return this.pageNum;
                    return "<u>" + this.pageNum + "</u>"
                },   
                // Remember pageNum is 1-based not zero based
                pageNum:i+1
            }));
        }
        
        buttons.add(isc.Label.create({
            autoDraw:false,
            contents:"&gt;&gt;",
            align:"center",            
            width:this.pagerButtonWidth,            
            cursor:"hand",
            gridPager:this,
            click:function () {
                this.gridPager.nextPages();
            }
        }));
        
        return isc.ToolStrip.create({
            width:1, overflow:"visible",
            styleName:"normal",
            members:buttons,
            autoDraw:false
        })
    },
    
    // methods to actually manage pages and navigation
    
    getTotalPages : function () {
        var total = this.grid.getTotalRows(),
            pages = Math.ceil(total / this.pageSize);
        // never return zero pages
        if (pages == 0) pages = 1;
        return pages;
    },
    
    goToPage : function (pageNum, forceRefresh) {
        // clamp to the end of the possible set of pages
        var pages = this.getTotalPages();
            
        if (pageNum > pages) pageNum = pages;
        if (pageNum < 1) pageNum = 1;       
        
        if (!forceRefresh && this.pageNum == pageNum) return;

        this.pageNum = pageNum;
        this._scrollingGrid = true;
        this.grid.scrollRecordIntoView((pageNum -1) * this.pageSize, false);
        this._scrollingGrid = false;
        // update the buttons
        this.updatePagerControls();
    },
    
    
    // given a page number, returns the first page in the "group" of pages we will show in
    // the navigation controls
    // We're showing N pages in the pager controls, so we'll always be starting with
    // a multiple of N
    getGroupStart : function (pageNum) {    
        var numPages = this.numPages,
            groupIndex = Math.ceil(pageNum / numPages)-1, 
            groupStart = 1 + (groupIndex * numPages);
        // If you're in the "last" group - shift the start if necessary so we always 
        // show numPages links (unless that would give us a negative value, of course)
        groupStart = Math.max(1, Math.min(groupStart, (this.getTotalPages() - (numPages-1))));
        return groupStart;
    },
    
    updatePagerControls : function () {
        var controls = this.pagerControls.members,
            pageNum = this.pageNum, numPages = this.numPages,
            total = this.getTotalPages();
            
        // if we're already showing a group that contains the page we moved to, don't shift
        // groups - confusing UI
        // [This can happen at the end of pages where we have overlapping groups]
        if (this.groupStart <= pageNum && ((this.groupStart + numPages -1) >= pageNum)) {
            groupStart = this.groupStart;
        } else {
            groupStart = this.getGroupStart(pageNum);
        }
        this.groupStart = groupStart; 
        
        var currentPage = this.groupStart;
            
        for (var i = 1; i < controls.length-1; i++) {
            controls[i].pageNum = currentPage;
            if (currentPage > total) controls[i].hide();
            else if (!controls[i].isVisible()) controls[i].show();
            
            if (currentPage == this.pageNum) controls[i].setCursor("default");
            else controls[i].setCursor("hand");
            currentPage += 1;
        }
        
        // show / hide the prev next buttons if appropriate
        if (groupStart == 1) controls[0].hide();
        else controls[0].show();
        
        if (groupStart + numPages > total) controls[controls.length-1].hide();
        else controls[controls.length-1].show();
        
        if (this.footer.isDrawn()) this.footer.markForRedraw();
    },
    
    previousPages : function () {
        var groupStart = this.groupStart;
        this.goToPage(groupStart - 1);
    },
    
    nextPages : function () {
        this.goToPage(this.groupStart + this.numPages);        
    }
});

</script>


<!-- Application code starts here -->
<script>

// load the supplyItem dataSource, and bind our grid to it
<isomorphic:loadDS ID="supplyItem"/>


isc.ListGrid.create({
    ID:"myGrid",
    autoDraw:false,
    
    dataSource:"supplyItem",
    
    // don't show body scrollbars by default
    bodyOverflow:"hidden"
});

isc.SearchForm.create({
    width:500,
    height:30,
    backgroundColor:"silver",
    numCols:5,
    fields:[
        {editorType:"button", endRow:false,
         title:"Search", click:"myGrid.filterData(form.getValues())"},

        {name:"itemName", title:"Name"},
        {name:"SKU", title:"SKU"}
    ]
});

isc.MyGridPager.create({
    ID:"myGridPager",
    border:"1px solid black",
    width:500,
    top:30, 
    // don't set height - this gets set up based on pageSize
    grid:myGrid,
    
    pageSize:9,
    numPages:3
})

</script>
</BODY>
</HTML>