package com.testcases.smartgwt.multifileitem.client;

/*
 * 
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.ui.RootPanel;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.MultiFileItem;
import com.smartgwt.client.widgets.form.fields.TextAreaItem;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.events.RecordClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import com.testcases.smartgwt.multifileitem.client.ds.DetailDS;
import com.testcases.smartgwt.multifileitem.client.ds.RESTMasterDS;

public class MultiFileItemTestCase implements EntryPoint {

    private DataSource multiUploadMaster;
    private DataSource multiUploadDetail;
    private ListGrid listGrid;

    private DynamicForm dynamicForm;

    @Override
    public void onModuleLoad() {
        loadDataSources();

        multiUploadMaster = DataSource.get(RESTMasterDS.MASTER_DS_ID);
        multiUploadDetail = DataSource.get(DetailDS.DETAIL_DS_ID);

        listGrid = new ListGrid();
        listGrid.setDataSource(multiUploadMaster);
        listGrid.setWidth(500);
        listGrid.setHeight(200);
        listGrid.setShowRollOver(false);
        listGrid.setAutoFetchData(true);
        listGrid.addRecordClickHandler(new RecordClickHandler() {
            @Override
            public void onRecordClick(RecordClickEvent event) {
                dynamicForm.editRecord(event.getRecord());
            }
        });

        TextAreaItem tai = new TextAreaItem(RESTMasterDS.MESSAGE, "Message");
        MultiFileItem multiFilePicker = new MultiFileItem(DetailDS.FILE_PATH);
        multiFilePicker.setAttribute("dataSource", multiUploadDetail.getID());

        dynamicForm = new DynamicForm();
        dynamicForm.setWidth(500);
        dynamicForm.setDataSource(multiUploadMaster);
        dynamicForm.setFields(tai, multiFilePicker);

        Button saveButton = new Button("Save Form");
        saveButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                dynamicForm.saveData();
            }
        });

        Button removeButton = new Button("Delete Row");
        removeButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                listGrid.removeSelectedData();
                dynamicForm.editNewRecord();
            }
        });
        Button cleareButton = new Button("Clear Form");
        cleareButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                dynamicForm.editNewRecord();
            }
        });

        VLayout topLayout = new VLayout();
        topLayout.addMember(listGrid);
        topLayout.addMember(removeButton);
        topLayout.addMember(dynamicForm);

        HLayout buttonLayout = new HLayout();
        buttonLayout.addMember(saveButton);
        buttonLayout.addMember(cleareButton);

        topLayout.addMember(buttonLayout);

        topLayout.draw();

        RootPanel.get().add(topLayout);
    }

    private void loadDataSources() {
        new RESTMasterDS();
        new DetailDS();
    }

}
