package com.testcases.smartgwt.multifileitem.client.ds;

import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.fields.DataSourceBinaryField;
import com.smartgwt.client.data.fields.DataSourceDateField;
import com.smartgwt.client.data.fields.DataSourceIntegerField;
import com.smartgwt.client.data.fields.DataSourceTextField;
import com.smartgwt.client.types.DSDataFormat;
import com.smartgwt.client.types.DSProtocol;

public class DetailDS extends DataSource {

    public static final String DETAIL_DS_ID = "detailDS";
    public static final String ID = "id";
    public static final String FILE_PATH = "filePath";
    public static final String MASTER_ID = "masterId";

    public DetailDS() {
        super();

        String dataURL = "fileUploadServlet";

        setID(DETAIL_DS_ID);

        DataSourceIntegerField id = new DataSourceIntegerField(ID, "id");
        id.setCanEdit(false);
        id.setPrimaryKey(true);
        id.setHidden(true);

        DataSourceBinaryField filePath = new DataSourceBinaryField(FILE_PATH, "attachment");
        filePath.setCanEdit(true);

        DataSourceTextField filePathFileName = new DataSourceTextField(FILE_PATH + "_filename", "Attachment FileName");
        filePathFileName.setHidden(true);

        DataSourceIntegerField filePathFileSize = new DataSourceIntegerField(FILE_PATH + "_filesize", "Attachment FileSize");
        filePathFileSize.setHidden(true);

        DataSourceDateField filePathDateCreated = new DataSourceDateField(FILE_PATH + "_date_created", "Attachment Date Created");
        filePathDateCreated.setHidden(true);

        DataSourceIntegerField masterId = new DataSourceIntegerField(MASTER_ID, "masterId");
        masterId.setForeignKey(RESTMasterDS.MASTER_DS_ID + "." + RESTMasterDS.ID);
        masterId.setHidden(true);

        setFields(id, filePath, filePathFileName, filePathFileSize, filePathDateCreated, masterId);

        setDataURL(dataURL);
        setDataFormat(DSDataFormat.JSON);
        setDataProtocol(DSProtocol.POSTMESSAGE);
    }

    @Override
    protected Object transformRequest(DSRequest dsRequest) {
        Object transformRequest = super.transformRequest(dsRequest);
        return transformRequest;
    }

    @Override
    protected void transformResponse(DSResponse response, DSRequest request, Object data) {
        super.transformResponse(response, request, data);
    }
}
