package com.testcases.smartgwt.multifileitem.client.ds;

import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.OperationBinding;
import com.smartgwt.client.data.RestDataSource;
import com.smartgwt.client.data.fields.DataSourceIntegerField;
import com.smartgwt.client.data.fields.DataSourceTextField;
import com.smartgwt.client.types.DSDataFormat;
import com.smartgwt.client.types.DSOperationType;
import com.smartgwt.client.types.DSProtocol;

public class RESTMasterDS extends RestDataSource {
    public static final String ID = "id";
    public static final String MESSAGE = "message";
    public static final String MASTER_DS_ID = "masterDS";

    public RESTMasterDS() {
        super();

        setID(MASTER_DS_ID);

        String recordXPath = "response/data/record";
        String fetchDataUrl = "rest/proxy/master/fetch";
        String addDataUrl = "rest/proxy/master/add";
        String updateDataUrl = "rest/proxy/master/update";
        String removeDataUrl = "rest/proxy/master/remove";

        DataSourceIntegerField id = new DataSourceIntegerField(ID, "Id");
        id.setPrimaryKey(true);
        id.setHidden(true);
        id.setCanEdit(false);

        DataSourceTextField message = new DataSourceTextField(MESSAGE, "Message");
        message.setRequired(true);
        message.setCanEdit(true);

        OperationBinding fetch = new OperationBinding();
        fetch.setOperationType(DSOperationType.FETCH);
        fetch.setDataProtocol(DSProtocol.POSTMESSAGE);
        OperationBinding add = new OperationBinding();
        add.setOperationType(DSOperationType.ADD);
        add.setDataProtocol(DSProtocol.POSTMESSAGE);
        OperationBinding update = new OperationBinding();
        update.setOperationType(DSOperationType.UPDATE);
        update.setDataProtocol(DSProtocol.POSTMESSAGE);
        OperationBinding remove = new OperationBinding();
        remove.setOperationType(DSOperationType.REMOVE);
        remove.setDataProtocol(DSProtocol.POSTMESSAGE);
        setOperationBindings(fetch, add, update, remove);

        setDataFormat(DSDataFormat.JSON);
        setRecordXPath(recordXPath);
        setFields(id, message);

        setFetchDataURL(fetchDataUrl);
        setAddDataURL(addDataUrl);
        setUpdateDataURL(updateDataUrl);
        setRemoveDataURL(removeDataUrl);
    }

    @Override
    protected Object transformRequest(DSRequest dsRequest) {
        // This is just to debug
        Object transformRequest = super.transformRequest(dsRequest);
        return transformRequest;
    }

    @Override
    protected void transformResponse(DSResponse response, DSRequest request, Object data) {
        // This is just to debug
        super.transformResponse(response, request, data);
    }
}