package com.testcases.smartgwt.multifileitem.restProxy;

import java.io.IOException;

import javax.ws.rs.core.Response;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gwt.core.shared.GWT;
import com.testcases.smartgwt.multifileitem.client.beans.MasterData;
import com.testcases.smartgwt.multifileitem.client.beans.MasterRecord;
import com.testcases.smartgwt.multifileitem.client.beans.RequestRESTMasterData;
import com.testcases.smartgwt.multifileitem.client.beans.RequestRESTMasterRecord;
import com.testcases.smartgwt.multifileitem.client.beans.ResponseRESTSuccessMaster;
import com.testcases.smartgwt.multifileitem.client.beans.ResponseRESTSuccessMasterDetail;

public class ProxyTestCaseImpl implements ProxyTestCaseIF {
    private final static MasterData masterData = new MasterData();
    private final static ObjectMapper om = new ObjectMapper();

    @Override
    public Response fetch(String request) {
        Response response = null;

        try {
            RequestRESTMasterData parsedRequest = om.readValue(request, RequestRESTMasterData.class);
            Integer startRow = parsedRequest.getStartRow();
            Integer endRow = parsedRequest.getEndRow();

            ResponseRESTSuccessMasterDetail detail = new ResponseRESTSuccessMasterDetail();
            detail.setStatus(0);
            if (startRow == null || endRow == null || startRow > endRow || startRow >= masterData.getRecord().size()) {
                detail.setData(masterData);

            } else {
                if (endRow != null) {
                    endRow = Math.max(endRow, masterData.getRecord().size());
                }
                MasterData pagedData = new MasterData();
                pagedData.setRecord(masterData.getRecord().subList(startRow, endRow));

                detail.setData(masterData);
            }
            detail.setTotalRows(detail.getData().getRecord().size());

            ResponseRESTSuccessMaster bodyContent = new ResponseRESTSuccessMaster();
            bodyContent.setResponse(detail);

            response = Response.ok(bodyContent).build();

        } catch (IOException e) {
            GWT.log("Error answering the fetch. Cause:" + e.getMessage());
        }

        return response;
    }

    @Override
    public Response add(RequestRESTMasterRecord request) {
        MasterRecord dataToAdd = request.getData();
        masterData.getRecord().add(dataToAdd);
        dataToAdd.setId(masterData.getRecord().size());

        MasterData data = new MasterData();
        data.getRecord().add(dataToAdd);
        ResponseRESTSuccessMasterDetail detail = new ResponseRESTSuccessMasterDetail();
        detail.setData(data);
        detail.setStartRow(0);
        detail.setEndRow(0);
        detail.setTotalRows(1);
        ResponseRESTSuccessMaster responseData = new ResponseRESTSuccessMaster();
        responseData.setResponse(detail);

        return Response.ok(responseData).build();
    }

    @Override
    public Response update(RequestRESTMasterRecord request) {
        MasterRecord newData = request.getData();

        int index = masterData.getRecord().indexOf(newData);
        MasterRecord dataOriginal = masterData.getRecord().get(index);
        dataOriginal.updateWidth(newData);

        MasterData data = new MasterData();
        data.getRecord().add(dataOriginal);
        ResponseRESTSuccessMasterDetail detail = new ResponseRESTSuccessMasterDetail();
        detail.setData(data);
        detail.setStartRow(0);
        detail.setEndRow(0);
        detail.setTotalRows(1);
        ResponseRESTSuccessMaster responseData = new ResponseRESTSuccessMaster();
        responseData.setResponse(detail);

        return Response.ok(responseData).build();
    }

    @Override
    public Response remove(RequestRESTMasterRecord request) {
        MasterRecord dataToAdd = request.getData();
        int register = masterData.getRecord().indexOf(dataToAdd);
        MasterRecord removed = masterData.getRecord().remove(register);

        MasterData data = new MasterData();
        data.getRecord().add(removed);
        ResponseRESTSuccessMasterDetail detail = new ResponseRESTSuccessMasterDetail();
        detail.setData(data);
        detail.setStartRow(0);
        detail.setEndRow(0);
        detail.setTotalRows(1);
        ResponseRESTSuccessMaster responseData = new ResponseRESTSuccessMaster();
        responseData.setResponse(detail);

        return Response.ok(responseData).build();
    }
}
