package com.testcases.smartgwt.multifileitem.fileUploadServlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase.InvalidContentTypeException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

@WebServlet(name = "fileUpload", urlPatterns = { "fileUpload" })
@MultipartConfig
public class FileUploadServlet extends HttpServlet {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        try {
            if (!ServletFileUpload.isMultipartContent(req)) {

                try {
                    StringBuffer sb = new StringBuffer();

                    ServletInputStream is = req.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);

                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);

                        line = br.readLine();
                    }

                    System.out.println("Content read:" + sb);
                    br.close();
                    isr.close();
                    is.close();

                } catch (IOException e1) {
                    String errorMessage = "Received content as a text/xml object not as a " + MediaType.MULTIPART_FORM_DATA;
                }

            } else {
                DiskFileItemFactory factory = new DiskFileItemFactory();

                // Configure a repository (to ensure a secure temp location is
                // used)
                ServletContext servletContext = this.getServletConfig().getServletContext();
                File repository = (File) servletContext.getAttribute("javax.servlet.context.tempdir");
                factory.setRepository(repository);

                // Create a new file upload handler
                ServletFileUpload upload = new ServletFileUpload(factory);
                // Parse the request
                try {
                    List<FileItem> items = upload.parseRequest(req);
                    System.out.println("Number of items: " + items);

                } catch (InvalidContentTypeException icte) {
                    String errorMessage = "Invalid content type in the upload request. Expected " + MediaType.MULTIPART_FORM_DATA + " but received "
                            + req.getContentType();

                } catch (Exception e) {

                }
            }
        } finally {
            try {
                ServletOutputStream os = res.getOutputStream();
                os.write("To be filled".getBytes());

            } catch (IOException e) {
                System.out.println("Error trying to write out the response to the servlet request");
            }
        }
    }
}
